/*---------------------------------------------------------------------------*\

    FILE....: echo.h
    TYPE....: C functions
    AUTHOR..: David Rowe
    DATE....: 15/9/02

    Host based echo canceller based on two path model.

\*---------------------------------------------------------------------------*/

#ifndef __ECHO__
#define __ECHO__

#define ECHO_TAPS   128

extern "C" {
void echo_open(void **pv);
void echo_close(void *pv);
void echo(void *pv, float e[], float y[], float s[], int n);
void echo_adapt(void *pv, int adapt);
float echo_get_Le(void *pv);
float echo_get_Le2(void *pv);
float echo_get_Ls(void *pv);
float echo_get_Ly(void *pv);
int echo_get_supp(void *pv);
int echo_get_double(void *pv);
float *echo_get_a(void *pv);
float *echo_get_a2(void *pv);
void echo_set_beta(void *pv, float beta);
}

#endif








